## 前言

HTTP 是前端开发人员必须知道的知识，也是日常处理请求都会接触的，但如果要构成知识体系，则需要一点点填充知识，今天就要讲下 HTTP 和 HTTPS 协议。

## HTTP 协议是什么

HTTP 协议是超文本传输协议的缩写，英文是`Hyper Text Transfer Protocol`。它是一个基于请求与响应，无状态的，应用层的协议，常基于`TCP/IP`协议传输数据，互联网上应用最为广泛的一种网络协议。设计 HTTP 的初衷是为了提供一种发布和接收 HTML 页面的方法。

HTTP 有多个版本，目前广泛使用的是`HTTP/1.1`版本。

## HTTP 特点

- **请求和响应**：基本的特性，由客户端发起请求，服务端响应
- **简单快速**：客户向服务器请求服务时，只需传送请求方法和路径。请求方法常用的有 GET、HEAD、POST。
- **灵活**：HTTP 允许传输任意类型的数据对象。传输的类型由`Content-Type`以标记。
- **无连接**：限制每次连接只处理一个请求。服务器处理完请求，并收到客户的应答后，即断开连接，但是却不利于客户端与服务器保持会话连接，为了弥补这种不足，产生了两项记录 HTTP 状态的技术，一个叫做 Cookie,一个叫做 Session。
- **无状态**：无状态是指协议对于事务处理没有记忆，后续处理需要前面的信息，则必须重传。

## 常见的请求方法

- GET：请求指定的页面信息，并返回实体主体。
- POST：向指定资源提交数据进行处理请求（例如提交表单或者上传文件）。
- HEAD：类似于 GET 请求，只不过返回的响应中没有具体的内容，用于获取报头
- PUT：从客户端向服务器传送的数据取代指定的文档的内容。
- DELETE：请求服务器删除指定的页面。

## HTTP 的缺点

- **明文传输**：数据完全肉眼可见，能够方便地研究和分析，但也容易被窃听

- HTTP 是不安全的，**无法验证通信双方的身份**，也不能判断报文是否被修改

## 为什么要用 HTTPS

HTTP 协议以明文方式传递信息，不提供任何方式的数据加密，不适合传输一些敏感信息，比如：各种账号、密码等信息，使用 HTTP 协议传输隐私信息非常不安全。

为了解决上述 HTTP 存在的问题，就出现了 HTTPS。

HTTPS 协议的主要作用可以分为两种：一种是建立一个信息安全通道，来保证数据传输的安全；另一种就是确认网站的真实性；解决了 HTTP 存在的缺点问题。

## 什么是 HTTPS?

HTTPS 协议（HyperText Transfer Protocol over Secure Socket Layer）：一般理解为`HTTP`+`SSL/TLS`，通过 SSL 证书来验证服务器的身份，并为浏览器和服务器之间的通信进行加密。

HTTPS 是一种通过计算机网络进行安全通信的传输协议，经由 HTTP 进行通信，利用`SSL/TLS`建立全信道，加密数据包。HTTPS 使用的主要目的是提供对网站服务器的身份认证，同时保护交换数据的隐私与完整性。

### SSL 是什么？

SSL（Secure Socket Layer，安全套接字层）：SSL 协议位于 `TCP/IP` 协议与各种应用层协议之间，为数据通讯提供安全支持。

TLS（Transport Layer Security，传输层安全）：其前身是 SSL，它最初的几个版本（SSL 1.0、SSL 2.0、SSL 3.0）由网景公司开发，目前使用最广泛的是`TLS 1.1`、`TLS 1.2`。

## 浏览器在使用 HTTPS 传输数据的流程是什么？

- 首先客户端通过 URL 访问服务器建立 SSL 连接。
- 服务端收到客户端请求后，会将网站支持的证书信息（证书中包含公钥）传送一份给客户端。
- 客户端的服务器开始协商 SSL 连接的安全等级，也就是信息加密的等级。
- 客户端的浏览器根据双方同意的安全等级，建立会话密钥，然后利用网站的公钥将会话密钥加密，并传送给网站。
- 服务器利用自己的私钥解密出会话密钥。
- 服务器利用会话密钥加密与客户端之间的通信。

## HTTPS 的特点

1. **内容加密**：采用混合加密技术，中间者无法直接查看明文内容
2. **验证身份**：通过证书认证客户端访问的是自己的服务器（确认网站的真实性）
3. **保护数据完整性**：防止传输的内容被中间人冒充或者篡改

**对称加密**

也叫做共享密钥加密。通信的双方使用同一个密钥对信息进行加密和解密，优点是加解密速度快。运用对称加密有一个前提就是在发送信息前双方都必须知道加密的规则，但是在互联网的环境下我们每天可能跟不同人发送信息，很多人我们之前根本没认识过，这种情况下我们根本不可能事先就约定好加密规则，那么我们就只能通过信息把加密规则（密钥）发送给对方，然后我们再根据加密规则来加密聊天信息，很显然这肯定是不可取的，不经过加密的数据在网络传输是没有任何安全性可言的。

**非对称加密**

又称作公开密钥加密。使用一对非对称的密钥，私钥保存在本地，公钥可以公开。发送密文的一方使用对方的公钥进行加密，接收方收到后，使用自己的私钥进行解密。优点是解密的私钥不需要进行分发。缺点是加解密速度慢，同时公钥可能被替换。

**混合加密**

使用混合加密的原因：非对称秘钥加密会比较慢，但是私钥不用传输安全，而对称秘钥方式则相反，为了充分利用两者优缺点，产生了混合加密机制
解决方案：即通信建立之初采用公开加密的方式传输对称秘钥方式中的同一秘钥，这样确保了共享秘钥的安全性，然后以后的通信均采用对称加密方式，这样提升了通信速度。

**数字摘要**

一段信息，经过摘要算法得到一串哈希值，就是摘要。通过单向 hash 函数对原文进行哈希，将需加密的明文“摘要”成一串固定长度(如 128bit)的密文，不同的明文摘要成的密文其结果总是不相同，同样的明文其摘要必定一致，并且即使知道了摘要也不能反推出明文。

**数字签名**

数字签名建立在公钥加密体制基础上，是公钥加密技术的另一类应用。摘要经过私钥的加密后，便有了一个新的名字 —— 数字签名。

**数字证书**

非对称加密过程需要用到公钥进行加密，那么公钥从何而来？其实公钥就被包含在数字证书中，数字证书通常来说是由受信任的数字证书颁发机构 CA，在验证服务器身份后颁发，证书中包含了一个密钥对（公钥和私钥）和所有者识别信息。数字证书（
实际就是一个 `.crt` 文件）被放到服务端，具有服务器身份验证和数据传输加密功能。

## HTTPS 的缺点

- HTTPS 协议多次握手，导致页面的加载时间延长近 50%；
- HTTPS 连接缓存不如 HTTP 高效，会增加数据开销和功耗；
- 申请 SSL 证书需要钱，功能越强大的证书费用越高。
- SSL 证书通常需要绑定 IP，不能在同一 IP 上绑定多个域名，IPv4 资源不可能支撑这个消耗。
- SSL 涉及到的安全算法会消耗 CPU 资源，对服务器资源消耗较大。

## 总结 HTTPS 和 HTTP 的区别

- **安全性**：HTTP 的连接很简单，是无状态的；HTTPS 协议是由 SSL+HTTP 协议构建的可进行加密传输、身份认证的网络协议，比 HTTP 协议安全。
- **连接端口**：HTTP 标准端口是 80，而 HTTPS 的标准端口是 443。
- **费用**：HTTPS 协议需要到 CA 申请证书，一般免费证书较少，因而需要一定费用
- **传输方式**：HTTP 是超文本传输协议，信息是明文传输，而 HTTPS 是 SSL 加密传输协议。
- **工作层**：在 OSI 网络模型中，HTTP 工作于应用层，而 HTTPS 工作在传输层。
- **工作耗时**：HTTP 耗时=TCP 握手，而 HTTPS 耗时=TCP 握手+SSL 握手。
- **显示形式**：HTTP 的 URL 以`http://`开头，而 HTTPS 的 URL 以`https://`开头。

## 参考

- [十分钟搞懂 HTTP 和 HTTPS 协议？](https://zhuanlan.zhihu.com/p/72616216)
